<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_aktiva_tetap extends MY_Model {

	function __construct(){
		parent::__construct();				
		$this->load->model('setting/m_user_log');
	}

	public function get_aktiva_tetap_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msat_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];		

		$this->db->select('ms_aktiva_tetap.*, msus_nm, mscb_nm, msta_nm, 
						a.msap_nm as msat_msap_nm_akt, b.msap_nm as msat_msap_nm_akp, c.msap_nm as msat_msap_nm_bbp, d.msap_nm as msat_disp_msap_nm');		
		$this->db->from('ms_aktiva_tetap');				
		$this->db->join('ms_user','ms_user.msus_no = ms_aktiva_tetap.msat_msus_no', 'left');
		$this->db->join('ms_cabang','ms_cabang.mscb_no = ms_aktiva_tetap.msat_mscb_no', 'left');		
		$this->db->join('ms_tipe_asset','msta_no = msat_msta_no', 'left');
		$this->db->join('ms_accper a', 'a.msap_no = msat_msap_no_akt','left');
		$this->db->join('ms_accper b', 'b.msap_no = msat_msap_no_akp','left');
		$this->db->join('ms_accper c', 'c.msap_no = msat_msap_no_bbp','left');
		$this->db->join('ms_accper d', 'd.msap_no = msat_disp_msap_no','left');

		$query_string = '';

		//Dispose status
		//1. Active
		//2. Disposed
		if(isset($arr_filter['dispose_status'])){			
			if($arr_filter['dispose_status'] == '1'){			
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' msat_disp_tgl = "0000-00-00"';
			}elseif($arr_filter['dispose_status'] == '2'){			
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' msat_disp_tgl != "0000-00-00"';
			}		
			unset($arr_filter['dispose_status']);
		}		

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}
		
		if(count($arr_filter) != 0){
			foreach ($arr_filter as $key => $value) {
				if($key == 'msat_msap_nm_akt') {
					unset($arr_filter['msat_msap_nm_akt']);
					$arr_filter['a.msap_nm'] = $value;
				}elseif ($key == 'msat_msap_nm_akp') {
					unset($arr_filter['msat_msap_nm_akp']);
					$arr_filter['b.msap_nm'] = $value;
				}elseif ($key == 'msat_msap_nm_bbp') {
					unset($arr_filter['msat_msap_nm_bbp']);
					$arr_filter['c.msap_nm'] = $value;
				}
			}

			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}	

	public function get_aktiva_tetap($msat_no){		
		$data = array();

		//Get aktiva_tetap header berdasarkan msat_no	
		$this->db->select('ms_aktiva_tetap.*, msus_no, msus_nm, mscb_no, mscb_nm, msta_no, msta_nm, msmp_metode, msmp_umur, msmp_tarif,
							a.msap_nm as msat_msap_nm_akt, b.msap_nm as msat_msap_nm_akp, c.msap_nm as msat_msap_nm_bbp, d.msap_nm as msat_disp_msap_nm');
		$this->db->from('ms_aktiva_tetap');		
		$this->db->join('ms_user','msus_no = msat_msus_no', 'left');
		$this->db->join('ms_cabang','mscb_no = msat_mscb_no', 'left');				
		$this->db->join('ms_tipe_asset','msta_no = msat_msta_no', 'left');
		$this->db->join('ms_mtd_penyusutan','msmp_no = msta_msmp_no', 'left');
		$this->db->join('ms_accper a', 'a.msap_no = msat_msap_no_akt','left');
		$this->db->join('ms_accper b', 'b.msap_no = msat_msap_no_akp','left');
		$this->db->join('ms_accper c', 'c.msap_no = msat_msap_no_bbp','left');
		$this->db->join('ms_accper d', 'd.msap_no = msat_disp_msap_no','left');
		$this->db->where('msat_no',$msat_no);
		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}
		
		//Get aktiva_tetap detail berdasarkan msat_no
		$this->db->select('md_aktiva_tetap.*, msap_nm');
		$this->db->from('md_aktiva_tetap');
		$this->db->join('ms_accper', 'msap_no = mdat_msap_no','left');
		$this->db->where('mdat_no',$msat_no);
		$this->db->order_by('mdat_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}

		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}	

	public function get_msat_no($msat_no){		
		$query = $this->db->get_where('ms_aktiva_tetap', array('msat_no' => $msat_no));
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function get_aktiva_tetap_cekint($msat_no, $msat_cekint){		
		$query = $this->db->get_where('ms_aktiva_tetap', array('msat_no' => $msat_no, 'msat_cekint' => $msat_cekint));				 
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_aktiva_tetap_cekint($msat_no){		
		//Update msat_cekint di tabel ms_aktiva_tetap
		$this->db->where('msat_no', $msat_no);
		$this->db->update('ms_aktiva_tetap', array('msat_cekint' => rand(0,10000)));
	}	
	
	public function aktiva_tetap_simpan($data){
		try {									
			$data['header']['msat_cekint'] = rand(0,10000);

			if($data['action'] == 'NEW'){					
				$this->db->insert('ms_aktiva_tetap',$data['header']);
				
				if(isset($data['detail'])){
					foreach ($data['detail'] as $key => $value){						
						$this->db->insert('md_aktiva_tetap',$data['detail'][$key]);
					}					
				}					

				$this->jurnal_simpan($data);
			}

			if($data['action'] == 'EDIT'){				
				$this->update_data($data);	
				$this->jurnal_simpan($data);
				// Simpan userlog
				$this->m_user_log->user_log_simpan($data['userlog']);					
			}					

			if($data['action'] == 'DISPOSE'){
				$this->update_header_aktiva_tetap($data);
				$this->jurnal_simpan($data);
			}					

			if($data['action'] == 'VOID'){				
				$this->db->where('msat_no', $data['header']['msat_no']);
				$this->db->update('ms_aktiva_tetap', array('msat_void'=>1));
				$this->jurnal_hapus($data);
				// Simpan userlog
				$this->m_user_log->user_log_simpan($data['userlog']);
			}

			if($data['action'] == 'STCOPY'){
				$this->db->where('msat_no', $data['header']['msat_no']);
				$this->db->update('ms_aktiva_tetap', array('msat_stcopy'=>$data['header']['msat_stcopy'], 'msat_cekint' => rand(0, 10000)));
			}			

			return 1;									
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function get_selectasset($tgl,$khusus_msat_no){
		$this->db->select('msat.*, msmp.msmp_metode, msmp.msmp_umur, msmp.msmp_tarif');
		$this->db->from('ms_aktiva_tetap msat');
		$this->db->join('ms_tipe_asset msta', 'msta.msta_no = msat.msat_msta_no', 'left');
		$this->db->join('ms_mtd_penyusutan msmp', 'msmp.msmp_no = msta.msta_msmp_no', 'left');		
		if($khusus_msat_no != null){
			$this->db->where(array('msat_no' => $khusus_msat_no, 'msmp_metode !=' => 'TD'));
		}else{
			$this->db->where(array('msat_void' => 0, 'msmp_metode !=' => 'TD', 'msat_disp_tgl' => '0000-00-00', 'msat_last_penyusutan <' => $tgl, 'msmp_umur >' => 'msat_seq_bln'));			
		}
		$query = $this->db->get();
		if($query->num_rows() > 0){
			return $query->result_array();				
		}
	}

	public function save_data_jurnal_penyusutanasset($data){		
		try {			
				$this->update_header_aktiva_tetap($data);
				$this->jurnal_simpan($data);
				return 1;
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function update_header_aktiva_tetap($data){				
		$this->db->where('msat_no', $data['header']['msat_no']);
		$this->db->update('ms_aktiva_tetap', $data['header']);
	}	

	private function update_data($data){		
		$this->db->where('msat_no', $data['header']['msat_no']);
		$this->db->update('ms_aktiva_tetap', $data['header']);
		
		$this->db->where(array('mdat_no' => $data['header']['msat_no']));
		$this->db->delete('md_aktiva_tetap');

		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {							
				$this->db->insert('md_aktiva_tetap', $data['detail'][$key]);
			}						
		}
	}

	private function jurnal_simpan($data){				
				
		// Generate CekInt
		$data['jurnal_h']['trju_cekint'] = rand(0,10000);			

		if($data['action'] == 'NEW' || $data['action'] == 'PENYUSUTAN' || $data['action'] == 'DISPOSE'){
			// Insert data header jurnal
			$this->db->insert('tr_jurnal',$data['jurnal_h']);
		}

		if($data['action'] == 'EDIT'){
			// Update data header jurnal
			$this->db->where('trju_no',$data['jurnal_h']['trju_no']);
			$this->db->update('tr_jurnal',$data['jurnal_h']);
			$this->db->delete('dt_jurnal',array('dtju_no' => $data['jurnal_h']['trju_no']));
		}					

		//Insert data detail jurnal
		if(isset($data['jurnal_d'])){
			$seq = 1;
			foreach ($data['jurnal_d'] as $key => $value) {														
				$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
				$data['jurnal_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
				$seq += 1;
			}		
		}		
	}

	private function jurnal_hapus($data){		
		$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
		$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
	}

}		